var examType = '';
var totalMarks = '';
var passingMarks = '';
var description = '';

function selectDropdownValue(selectName, val) {
    let theSelect = document.getElementById(selectName);
    for (let j = 0; j < theSelect.options.length; j++) {
        let optVal = theSelect.options[j].value.trim();
        if (optVal == val.trim()) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}

function loadDataDropdown(selectName, results, centerId) {
    var theSelect = document.getElementById(selectName);

    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("semester")) {
            if (i == 0) {
                options.value = options.text = "SELECT SEMESTER";
                theSelect.add(options);
                options.selected = true;
                options = document.createElement("option");
            }
            options.value = results[i].semesterValue.toUpperCase();
            options.text = results[i].semesterValue.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}

function loadDataDrop(selectExamType) {
    var theSelect = document.getElementById(selectExamType);

    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    options = document.createElement("option");
    options.value = "";

    options.disabled = false;

    options = document.createElement("option");
    options.value = 'SELECT EXAM TYPE';
    options.text = 'SELECT EXAM TYPE';
    options.setAttribute('selected', 'selected');
    theSelect.add(options);

    options = document.createElement("option");
    options.value = 'SEMESTER EXAM';
    options.text = 'SEMESTER EXAM';
    theSelect.add(options);

    options = document.createElement("option");
    options.value = 'CE-1';
    options.text = 'CE-1';
    theSelect.add(options);

    options = document.createElement("option");
    options.value = 'CE-2';
    options.text = 'CE-2';
    theSelect.add(options);

    options = document.createElement("option");
    options.value = 'ATTENDANCE MARKS';
    options.text = 'ATTENDANCE MARKS';
    theSelect.add(options);
    return 1;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function addTableRowEdit(masterList, flag) {
    const mytable = document.getElementById("subjectTableBody");
    var newRow,
        newCell;

    mytable.innerHTML = '';
    examList = masterList[0].examType.split("::");
    examTotalMarksList = masterList[0].examTotalMarks.split("::");
    examPassingMarksList = masterList[0].examPassingMarks.split("::");
    examDescription = masterList[0].examDescription.split("::");
    for (let i = 0; i < examList.length; i++) {

        var currentIndex = mytable.rows.length;
        var newRow = document.createElement("tr");
        mytable.appendChild(newRow);

        newCell = document.createElement("td");
        var select = document.createElement("select");
        select.setAttribute("class", "form-control custom-select");
        select.setAttribute("type", "");
        select.setAttribute("id", "selectExamType" + (currentIndex + 1));
        newCell.appendChild(select);
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var totalMarks = document.createElement("input");
        totalMarks.setAttribute("class", "form-control tAC");
        totalMarks.setAttribute("id", "totalMarks" + (currentIndex + 1));
        totalMarks.setAttribute("type", "number");
        totalMarks.setAttribute("placeholder", "Total Marks");
        totalMarks.setAttribute("value", examTotalMarksList[i]);
        newCell.appendChild(totalMarks);
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var passingMarks = document.createElement("input");
        passingMarks.setAttribute("class", "form-control tAC");
        passingMarks.setAttribute("id", "passingMarks" + (currentIndex + 1));
        passingMarks.setAttribute("type", "number");
        passingMarks.setAttribute("placeholder", "Passing Marks");
        passingMarks.setAttribute("value", examPassingMarksList[i]);
        newCell.appendChild(passingMarks);
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var description = document.createElement("input");
        description.setAttribute("class", "form-control tAC");
        description.setAttribute("id", "description" + (currentIndex + 1));
        description.setAttribute("type", "text");
        description.setAttribute("placeholder", "Description");
        description.setAttribute("value", examDescription[i]);
        newCell.appendChild(description);
        newRow.appendChild(newCell);

        if (i != 0) {
            newCell = document.createElement("td");
            var deleteButton = document.createElement("input");
            deleteButton.setAttribute("type", "button");
            deleteButton.setAttribute("id", "deleteButton" + (currentIndex + 1));
            deleteButton.setAttribute("class", "imageButton deleteButton form-control");
            deleteButton.setAttribute("title", "Delet Current Row");
            deleteButton.setAttribute("onclick", "deleteRow(this)");
            newCell.appendChild(deleteButton);
            newRow.appendChild(newCell);
        } else {
            newCell = document.createElement("td");
            newRow.appendChild(newCell);
        }
        loadDataDrop("selectExamType" + (currentIndex + 1));
        selectDropdownValue("selectExamType" + (currentIndex + 1), examList[i]);
    }
}

function setHeaders() {
    subjectId = '',
        semester = '',
        subjectName = '',
        subjectGrandTotalMarks = '';
    examType = '';
    totalMarks = '';
    passingMarks = '';
    description = '';

    subjectId = document.getElementById("subjectId").value.trim();
    semester = document.getElementById("semester").value.trim().toUpperCase();
    subjectName = document.getElementById("subjectName").value.trim().toUpperCase();
    subjectGrandTotalMarks = document.getElementById("subjectGrandTotalMarks").value.trim();

    return 1;
}

function addNewSubjectValidation() {
    // select semester validation
    if (semester == "SELECT SEMESTER") {
        document.getElementById("semester").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Select Semester");
        return 0;
    } else {
        document.getElementById("semester").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    // subject name validation
    if (subjectName.length <= 0) {
        document.getElementById("subjectName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter Subject Name");
        return 0;
    } else {
        document.getElementById("subjectName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    // Total Marks validation
    if (subjectGrandTotalMarks.length <= 0) {
        document.getElementById("subjectGrandTotalMarks").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter Total Marks");
        return 0;
    } else {
        document.getElementById("subjectGrandTotalMarks").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }
    console.log(parseInt(subjectGrandTotalMarks));

    if (parseInt(subjectGrandTotalMarks) < 0) {
        document.getElementById("subjectGrandTotalMarks").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Total Marks cannot be negative");
        return 0;
    } else {
        document.getElementById("subjectGrandTotalMarks").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    showError('', '', '');
    return 1;
}

function resetTableErrors() {
    var table = document.getElementById("subjectTableBody");
    for (var r = 0, n = table.rows.length; r < n; r++) {
        table.rows[r].cells[0].getElementsByTagName("select")[0].style.backgroundColor = "";

        table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";
        table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";
        table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
    }
}

function marksBreakupTableValidation() {
    resetTableErrors();
    var table = document.getElementById("subjectTableBody");

    for (var r = 0, n = table.rows.length; r < n; r++) {
        //Exam Type
        if (table.rows[r].cells[0].getElementsByTagName("select")[0].selectedIndex == '0') {
            table.rows[r].cells[0].getElementsByTagName("select")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Select Exam Type");
            return 0;
        } else table.rows[r].cells[0].getElementsByTagName("select")[0].style.backgroundColor = "";

        // Total Marks   
        if (table.rows[r].cells[1].getElementsByTagName("input")[0].value.trim() == '') {
            table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Enter Total Marks.");
            return 0;
        } else table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";

        if (table.rows[r].cells[1].getElementsByTagName("input")[0].value.trim() < 0) {
            table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Total Marks Can Not be Nagative.");
            return 0;
        } else table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";

        // Passing Marks
        if (table.rows[r].cells[2].getElementsByTagName("input")[0].value.trim() == '') {
            table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Enter Passing Marks.");
            return 0;
        } else table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";

        if (parseFloat(table.rows[r].cells[2].getElementsByTagName("input")[0].value) > parseFloat(table.rows[r].cells[1].getElementsByTagName("input")[0].value)) {
            table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Passing Marks cannot be greater than total marks.");
            return 0;
        } else table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";

        if (table.rows[r].cells[2].getElementsByTagName("input")[0].value.trim() < 0) {
            table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Passing Marks Can Not be Nagative.");
            return 0;
        } else table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";

        // Description
        if (table.rows[r].cells[3].getElementsByTagName("input")[0].value.trim() == '') {
            table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Enter Description.");
            return 0;
        } else table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
    }
    showError('', '', '');
    return 1;
}

function addTableRow() {
    if (marksBreakupTableValidation() == 0) return;
    resetTableErrors();

    var mytable = document.getElementById("subjectTableBody"),
        newRow,
        newCell;
    // console.log(mytable);
    // console.log(newRow);
    // console.log(newCell);

    var currentIndex = mytable.rows.length;
    // console.log(currentIndex);

    var newRow = document.createElement("tr");
    mytable.appendChild(newRow);

    newCell = document.createElement("td");
    var select = document.createElement("select");
    select.setAttribute("class", "form-control custom-select");
    select.setAttribute("type", "");
    select.setAttribute("id", "selectExamType" + (currentIndex + 1));
    newCell.appendChild(select);
    newRow.appendChild(newCell);

    newCell = document.createElement("td");
    var totalMarks = document.createElement("input");
    totalMarks.setAttribute("class", "form-control tAC");
    totalMarks.setAttribute("id", "totalMarks" + (currentIndex + 1));
    totalMarks.setAttribute("type", "number");
    totalMarks.setAttribute("placeholder", "Total Marks");
    newCell.appendChild(totalMarks);
    newRow.appendChild(newCell);

    newCell = document.createElement("td");
    var passingMarks = document.createElement("input");
    passingMarks.setAttribute("class", "form-control tAC");
    passingMarks.setAttribute("id", "passingMarks" + (currentIndex + 1));
    passingMarks.setAttribute("type", "number");
    passingMarks.setAttribute("placeholder", "Passing Marks");
    newCell.appendChild(passingMarks);
    newRow.appendChild(newCell);

    newCell = document.createElement("td");
    var description = document.createElement("input");
    description.setAttribute("class", "form-control tAC");
    description.setAttribute("id", "description" + (currentIndex + 1));
    description.setAttribute("type", "text");
    description.setAttribute("placeholder", "Description");
    newCell.appendChild(description);
    newRow.appendChild(newCell);

    newCell = document.createElement("td");
    var deleteButton = document.createElement("input");
    deleteButton.setAttribute("type", "button");
    deleteButton.setAttribute("id", "deleteButton" + (currentIndex + 1));
    deleteButton.setAttribute("class", "imageButton deleteButton form-control");
    deleteButton.setAttribute("title", "Delet Current Row");
    deleteButton.setAttribute("onclick", "deleteRow(this)");
    newCell.appendChild(deleteButton);
    newRow.appendChild(newCell);

    loadDataDrop("selectExamType" + (currentIndex + 1));

}

function deleteRow(rows) {
    var tempRowId = (rows.id).split("deleteButton");
    document.getElementById("subjectTableBody").deleteRow(tempRowId[1] - 1);
    var table = document.getElementById("subjectTableBody");
    for (let i = 0; i < table.rows.length; i++) {

        table.rows[i].cells[0].getElementsByTagName("select")[0].id = 'selectExamType' + (i + 1);

        table.rows[i].cells[1].getElementsByTagName("input")[0].id = 'totalMarks' + (i + 1);
        table.rows[i].cells[2].getElementsByTagName("input")[0].id = 'passingMarks' + (i + 1);
        table.rows[i].cells[3].getElementsByTagName("input")[0].id = 'description' + (i + 1);
    }
}

var sumTotalMarks;
function prepareTableData() {
    var table = document.getElementById("subjectTableBody");
    for (let r = 0, n = table.rows.length; r < n; r++) {
        let tempExamType = table.rows[r].cells[0].getElementsByTagName("select")[0].value.toUpperCase();
        let tempTotalMarks = table.rows[r].cells[1].getElementsByTagName("input")[0].value;
        let tempPassingMarks = table.rows[r].cells[2].getElementsByTagName("input")[0].value;
        let tempDescription = table.rows[r].cells[3].getElementsByTagName("input")[0].value;
        examType += tempExamType + "::";
        totalMarks += tempTotalMarks + "::";
        passingMarks += tempPassingMarks + "::";
        description += tempDescription + "::";
    }
    examType = examType.slice(0, -2).trim();
    totalMarks = totalMarks.slice(0, -2).trim();
    passingMarks = passingMarks.slice(0, -2).trim();
    description = description.slice(0, -2).trim();

    totalMarksList = totalMarks.split("::");
    // console.log(totalMarksList);
    sumTotalMarks = 0;
    if (totalMarksList[0] != '') {
        for (i = 0; i < totalMarksList.length; i++) {
            sumTotalMarks = sumTotalMarks += parseInt(totalMarksList[i]);
        }
    }
    return 1;
}

function checkTotal() {
    // console.log(sumTotalMarks);
    if (subjectGrandTotalMarks != sumTotalMarks) {
        showError('errorMessage', '', "Sum of Marks doesn't match with the total declared");
        return 0;
    }
    return 1;
}

function updateSubject() {
    // var flagForEdit=true;
    var saveFlag = 'editSubject';
    if (setHeaders() == 0) return 0;
    if (addNewSubjectValidation() == 0) return 0;
    if (marksBreakupTableValidation() == 0) return 0;
    if (prepareTableData() == 0) return 0;
    if (checkTotal() == 0) return 0;
    console.log(subjectName, semester, examType, description, subjectGrandTotalMarks);
    document.getElementById('successMessage').innerHTML = 'Updating Details. Please wait...';
    document.getElementById("editButton").disabled = true;
    $.post('updateSubject.php', {
        'saveFlag': saveFlag,
        'subjectId': subjectId,
        'semester': semester,
        'subjectName': subjectName,
        'subjectGrandTotalMarks': subjectGrandTotalMarks,
        'examType': examType,
        'totalMarks': totalMarks,
        'passingMarks': passingMarks,
        'description': description
    }, function (data) {
        document.getElementById('successMessage').innerHTML = ' Details Successfuly Updated. Please wait The page will get auto-refresh...';
        document.getElementById("editButton").disabled = false;
        location.reload();
    });
}